% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vap.R
\name{vap}
\alias{vap}
\alias{vap_dbl}
\alias{vap_chr}
\alias{vap_lgl}
\alias{vap_int}
\title{vap: Vector apply functions}
\usage{
vap_dbl(.data, .f, ...)

vap_chr(.data, .f, ...)

vap_lgl(.data, .f, ...)

vap_int(.data, .f, ...)
}
\arguments{
\item{.data}{Input object–numeric, character, list, data frame, etc.–over
which elements will be iterated. If matrix or data frame, each
column will be treated as the elements which are to be iterated over.}

\item{.f}{Function to apply to each element of input object. This can be
written as a single function name e.g., \code{mean}, a formula-like
function call where '.x' is assumed to be the iterated over element of
input data e.g., \code{~ mean(.x)}, or an in-line function definition e.g.,
\code{function(x) mean(x)}.}

\item{...}{Other values passed to function call.}
}
\value{
A double vector

A character vector

A logical vector

A integer vector
}
\description{
Functions that apply expressions to input data objects and return atomic
vectors e.g., numeric (double), character, logical.

vap_dbl: Iterate over input and return double(s)

vap_chr: Iterate over input and return character(s)

vap_lgl: Iterate over input and return logical(s)

vap_int: Iterate over input and return integer(s)
}
\examples{

## character
vap_chr(letters, ~ paste0(.x, "."))

## double
vap_dbl(rnorm(4), round, 3)

## logical
vap_lgl(letters, ~ .x \%in\% c("a", "e", "i", "o", "u"))

## integer
vap_int(rnorm(5), ~ as.integer(.x))

}
\seealso{
\code{\link{dap}} \code{\link{lap}}
}
