% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_scatter}
\alias{plot_scatter}
\title{Scatter graph}
\usage{
plot_scatter(data, label_x = "", label_y = "", colors = NULL)
}
\arguments{
\item{data}{long data.frame with columns \code{x}, \code{value}, \code{variable}}

\item{label_x}{x‑axis label}

\item{label_y}{y‑axis label}

\item{colors}{optional color(s); for numeric \code{variable}, supply a gradient as c(low, high)}
}
\value{
return a ggplot2::ggplot graphic
}
\description{
Scatter plot from a long data.frame with columns named \code{x}, \code{value}, and \code{variable}.
}
\details{
Colors are mapped to \code{variable}. If \code{variable} is numeric, a gradient color scale is used when \code{colors} is provided.
}
\examples{
grf <- plot_scatter(iris |> dplyr::select(x = Sepal.Length,
value = Sepal.Width, variable = Species),
label_x = "Sepal.Length", label_y = "Sepal.Width",
colors=c("red", "green", "blue"))
plot(grf)
}
