% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_pam.R
\name{cluster_pam}
\alias{cluster_pam}
\title{PAM}
\usage{
cluster_pam(k = 1)
}
\arguments{
\item{k}{The number of clusters to generate.}
}
\value{
A PAM object.
}
\description{
Creates a clusterer object that
uses the Partition Around Medoids (PAM) method
It wraps the cluster library.
}
\examples{
# setup clustering
model <- cluster_pam(k = 3)

#load dataset
data(iris)

# build model
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)

# evaluate model using external metric
eval <- evaluate(model, clu, iris$Species)
eval
}
