% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{redraw_blocks}
\alias{redraw_blocks}
\title{Inspect revised block bounding boxes}
\usage{
redraw_blocks(json, token_df, dir = getwd())
}
\arguments{
\item{json}{filepath of a JSON file obtained using \code{dai_async()}}

\item{token_df}{a token data frame generated with \code{build_token_df()},
\code{reassign_tokens()}, or \code{reassign_tokens2()}.}

\item{dir}{path to the desired output directory.}
}
\value{
no return value, called for side effects
}
\description{
Tool to visually check the order of block bounding boxes after
manual processing (e.g. block reordering or splitting). Takes as its main
input a token dataframe generated with \code{build_token_df()},
\code{reassign_tokens()}, or \code{reassign_tokens2()}.
The function plots the block bounding boxes onto images of the submitted
document. Generates an annotated .png file for each page in the
original document.
}
\details{
Not vectorized, but documents can be multi-page.
}
\examples{
\dontrun{
redraw_blocks("pdf_output.json", revised_token_df, dir = tempdir())
}
}
