% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{backDoorGraph}
\alias{backDoorGraph}
\title{Back-Door Graph}
\usage{
backDoorGraph(x)
}
\arguments{
\item{x}{the input graph, a DAG, MAG, PDAG, or PAG.}
}
\description{
Removes every first edge on a proper causal path from \code{x}.
If \code{x} is a MAG or PAG, then only \dQuote{visible} directed
edges are removed (Zhang, 2008).
}
\examples{
g <- dagitty( "dag { x <-> m <-> y <- x }" )
backDoorGraph( g ) # x->y edge is removed

g <- dagitty( "mag { x <-> m <-> y <- x }" )
backDoorGraph( g ) # x->y edge is not removed

g <- dagitty( "mag { x <-> m <-> y <- x <- i }" )
backDoorGraph( g ) # x->y edge is removed

}
\references{
J. Zhang (2008), Causal Reasoning with Ancestral Graphs. 
\emph{Journal of Machine Learning Research} 9: 1437-1474.
}
