% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{validate_stats_dm}
\alias{validate_stats_dm}
\alias{validate_stats_dm.cafs}
\alias{validate_stats_dm.quantiles}
\alias{validate_stats_dm.delta_funs}
\alias{validate_stats_dm.sum_dist}
\alias{validate_stats_dm.fit_stats}
\alias{validate_stats_dm.stats_dm}
\title{Validate a stats_dm Object}
\usage{
validate_stats_dm(stat_df)

\method{validate_stats_dm}{cafs}(stat_df)

\method{validate_stats_dm}{quantiles}(stat_df)

\method{validate_stats_dm}{delta_funs}(stat_df)

\method{validate_stats_dm}{sum_dist}(stat_df)

\method{validate_stats_dm}{fit_stats}(stat_df)

\method{validate_stats_dm}{stats_dm}(stat_df)
}
\arguments{
\item{stat_df}{A \code{data.frame} of class \code{stats_dm}, \code{cafs}, \code{quantiles},
\code{delta_funs}, \code{sum_dist}, or \code{fit_stats} containing the calculated statistics
to be validated.}
}
\value{
Returns the unmodified \code{stat_df} for convenience.
}
\description{
\code{validate_stats_dm} is an internal (i.e., not exported) generic function to
ensure that \code{stats_dm} objects, as well as their specific subclasses
(\code{cafs}, \code{quantiles}, \code{delta_funs}, \code{sum_dist}, and \code{fit_stats}), meet the
necessary structural and column requirements. Each method performs
class-specific validation checks.
}
\details{
The validation process checks for required columns and structure based on the
class of \code{stat_df}. Each class has specific requirements:
\itemize{
\item \strong{\code{validate_stats_dm.stats_dm}:} Ensures \code{stat_df} is a \code{data.frame}.
\item \strong{\code{validate_stats_dm.cafs}:} Checks for the presence of \code{"Bin"}, \code{"Cond"},
and exactly one column prefixed with \code{"P_"}
\item \strong{\code{validate_stats_dm.quantiles}:} Requires \code{"Prob"}, \code{"Cond"}, and exactly
two columns prefixed with \code{"Quant_"}
\item \strong{\code{validate_stats_dm.delta_funs}:} Ensures \code{"Prob"} exists, at least two
columns prefixed with \code{"Quant_"}, and at least one column  each \code{Avg_}
and \code{Delta_}
\item \strong{\code{validate_stats_dm.sum_dist}:} Checks for a \code{"Source"} column.
\item \strong{\code{validate_stats_dm.fit_stats}:} Checks for \code{"Log_Like"}, \code{"AIC"}, and
\code{"BIC"} columns.
}
}
\keyword{internal}
