% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{copy_class_attributes}
\alias{copy_class_attributes}
\alias{copy_class_attributes.stats_dm}
\title{Copy Class Attributes from One Object to Another}
\usage{
copy_class_attributes(old, new)

\method{copy_class_attributes}{stats_dm}(old, new)
}
\arguments{
\item{old}{The source object from which class attributes will be copied.}

\item{new}{The target object to which class attributes will be assigned.}
}
\value{
The modified \code{new} object with attributes and class from \code{old}.
}
\description{
This function transfers class attributes from an \code{old} object to a \code{new}
object, ensuring that \code{new} inherits the class structure and missing
attributes of \code{old}. The primary purpose is to enforce class consistency and
restore any lost attributes when modifying or combining objects. It is
used in the internals of the package and it is not exported.
}
\details{
The function assumes that all class attributes of \code{new} can be found in
\code{old}. Note also, that the order of attributes is not ensured.
}
\keyword{internal}
