% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetryDetection.R
\name{symmetryDetection}
\alias{symmetryDetection}
\title{Search for symmetries in the loaded model}
\usage{
symmetryDetection(f, obsvect = NULL, prediction = NULL,
  initial = NULL, ansatz = "uni", pMax = 2, inputs = NULL,
  fixed = NULL, cores = 1, allTrafos = FALSE)
}
\arguments{
\item{f}{object containing the ODE for which \code{as.eqnvec()} is defined}

\item{obsvect}{vector of observation functions}

\item{prediction}{vector containing prediction to be tested}

\item{initial}{vector containing initial values}

\item{ansatz}{type of infinitesimal ansatz used for the analysis (uni, par, multi)}

\item{pMax}{maximal degree of infinitesimal ansatz}

\item{inputs}{specify the input variables}

\item{fixed}{variables to concider fixed}

\item{cores}{maximal number of cores used for the analysis}

\item{allTrafos}{do not remove transformations with a common parameter factor}
}
\description{
This function follows the method published in [1].

The function calls a python script via rPython. Usage problems might occur when different python versions are used. The script was written and tested for python 2.7.12, sympy 0.7.6.

Recently, users went into problems with RJSONIO when rPython was used. Unless a sound solution is available, please try to reinstall RJSONIO in these cases.
}
\examples{
\dontrun{
eq <- NULL
eq <- addReaction(eq, "A", "B", "k1*A")
eq <- addReaction(eq, "B", "A", "k2*B")

observables <- eqnvec(Aobs = "alpha * A")

symmetryDetection(eq, observables)

}
}
\references{
[1]
\url{https://journals.aps.org/pre/abstract/10.1103/PhysRevE.92.012920}
}
