% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalogue.R
\name{czso_filter_catalogue}
\alias{czso_filter_catalogue}
\title{Filter the catalogue using a set of keywords}
\usage{
czso_filter_catalogue(catalogue, search_terms)
}
\arguments{
\item{catalogue}{a catalogue as returned by \code{czso_get_catalogue()}}

\item{search_terms}{#' A regex pattern (incl. plain text), or a vector of regex patterns, to filter the catalogue by.
A case-insensitive filter is performed on the title, description and keywords.
The search returns only catalogue entries where all the patterns are matched anywhere within the title, description or keywords.}
}
\value{
A tibble with the filtered catalogue.
}
\description{
Filter the catalogue using a set of keywords
}
\examples{
ctlg <- czso_get_catalogue()
czso_filter_catalogue(ctlg, search_terms = c("kraj", "me?zd"))
czso_filter_catalogue(ctlg, search_terms = c("úmrt", "orp"))
czso_filter_catalogue(ctlg, search_terms = c("kraj", "vazba", "orp"))
czso_filter_catalogue(ctlg, search_terms = c("ISCO", "číselník"))
czso_filter_catalogue(ctlg, search_terms = c("zaměstnání", "číselník"))
}
\seealso{
Other Core workflow: 
\code{\link{czso_get_catalogue}()},
\code{\link{czso_get_codelist}()},
\code{\link{czso_get_table}()}
}
\concept{Core workflow}
