\name{covProb.sim}
\alias{covProb.sim}
\title{Coverage probability simulation}
\description{
This function runs a simulation to calculate the coverage probability over a number of iterations of the confidence intervals generated by the \code{ci.cvAUC} function. The true distribution given by the default parameters has a size of 200,000 and is a mixture of multivariate normals.  Half of the points come from a 10-dimensional \code{N(0,I)} and the other half from a 10-dimensional \code{N(0.5,I)} distribution, where \code{I} is the identity matrix.  The observations from \code{N(0,I)} are given class label 0 (negative class), and the observations from \code{N(0.5,I)} are given class label 1 (positive class).
}
\usage{
covProb.sim(iters = 1000, n = 1000, 
  dist0 = list(mu=rep(0,10), Sigma=diag(10), N=100000), 
  dist1 = list(mu=rep(0.5,10), Sigma=diag(10), N=100000), 
  confidence = 0.95, V = 10, parallel = FALSE)
}
\arguments{
  \item{iters}{Number of iterations in the experiment.}
  \item{n}{ Integer. Sample size.}
  \item{dist0}{
  A list defining the negative class distribution. \code{mu} is a numeric vector of means, \code{Sigma} is the covariance matrix and \code{N} is the size of true distribution of negative class.
}
  \item{dist1}{
  A list defining the positive class distribution. \code{mu} is a numeric vector of means, \code{Sigma} is the covariance matrix and \code{N} is the size of true distribution of positive class.
}
\item{confidence}{A number between 0 and 1 representing the confidence.}
\item{V}{The number of cross-validation folds.}
\item{parallel}{Logical.  If \code{TRUE}, the \code{parallel} package (available in R >= 2.14.0) will parallelize the simulation across all available cores.}
}
\details{
The dimensionality of the positive and negative samples must be equal. 
}
\value{
\item{k}{Integer representing the number of predictor variables.}
\item{cov.prov}{A number between 0 and 1 which is the calculated coverage probability across all iterations.}
\item{runtime}{An object of class 'difftime' that displays runtime of the function.}
}
\references{

LeDell, Erin; Petersen, Maya L.; and van der Laan, Mark J., ``Computationally Efficient Confidence Intervals for Cross-validated Area Under the ROC Curve Estimates.''  (December 2012). U.C. Berkeley Division of Biostatistics Working Paper Series. Working Paper 304.\cr
\url{http://biostats.bepress.com/ucbbiostat/paper304}

}
\author{
Erin LeDell \email{ledell@berkeley.edu}
}

\seealso{
\code{\link[ROCR]{prediction}}, \code{\link[ROCR]{performance}}, \code{\link{ci.cvAUC}}
}
\examples{
# Warning: This simulation takes a long time to run.  
# The runtime for the default parameters on a 8GB RAM machine with the parallel option
# and 8 cores is around 2 hours.

\dontrun{

library(cvAUC)
set.seed(1)
out <- covProb.sim(parallel=TRUE)

# The output is given as follows:
# > out
# $k
# [1] 10
# 
# $cov.prob
# [1] 0.952
# 
# $runtime
# Time difference of 2.003833 hours

}
}