% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{tp}
\alias{tp}
\alias{tn}
\alias{fp}
\alias{fn}
\title{Extract number true / false positives / negatives}
\usage{
tp(tp, ...)

tn(tn, ...)

fp(fp, ...)

fn(fn, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{...}{for capturing additional arguments passed by method.}

\item{tn}{(numeric) number of true negatives.}

\item{fp}{(numeric) number of false positives.}

\item{fn}{(numeric) number of false negatives.}
}
\description{
Extract the number of true positives (tp), false positives (fp),
true negatives (tn), or false negatives (fn).
The inputs must be vectors of equal length. Mainly useful for \code{plot_cutpointr}.
}
\examples{
tp(10, 5, 20, 10)
tp(c(10, 8), c(5, 7), c(20, 12), c(10, 18))
fp(10, 5, 20, 10)
tn(10, 5, 20, 10)
fn(10, 5, 20, 10)
}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cohens_kappa}}, \code{\link{cutpoint}},
  \code{\link{false_omission_rate}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{sensitivity}},
  \code{\link{specificity}}, \code{\link{sum_ppv_npv}},
  \code{\link{sum_sens_spec}}, \code{\link{total_utility}},
  \code{\link{tpr}}, \code{\link{youden}}
}
