% Generated by roxygen2 (4.0.2): do not edit by hand
\name{curl_download}
\alias{curl_download}
\title{Download file}
\usage{
curl_download(url, destfile, quiet = FALSE, mode = "w")
}
\arguments{
\item{url}{A character string naming the URL of a resource to be downloaded.}

\item{destfile}{A character string with the name where the downloaded file is saved.
Tilde-expansion is performed.}

\item{quiet}{If \code{TRUE}, suppress status messages (if any), and the progress bar.}

\item{mode}{A character string specifying the mode with which to write the file. Useful values are \code{"w"},
\code{"wb"} (binary), \code{"a"} (append) and \code{"ab"}.}
}
\description{
Libcurl implementation of \code{C_download} (the "internal" download method).
Designed to behave similar to \code{\link{download.file}}.
}
\examples{
\dontrun{download large file
url <- "http://www2.census.gov/acs2011_5yr/pums/csv_pus.zip"
tmp <- tempfile()
curl_download(url, tmp)
}
}

