% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{cuml_predict}
\alias{cuml_predict}
\title{Make predictions on new data points.}
\usage{
cuml_predict(model, x, output_class_probabilities = NULL, ...)
}
\arguments{
\item{model}{A trained CuML model.}

\item{x}{A matrix or dataframe containing new data points.}

\item{output_class_probabilities}{Whether to output class probabilities.
NOTE: setting \code{output_class_probabilities} to \code{TRUE} is only
valid when the model being applied is a classification model and supports
class probabilities output. CuML classification models supporting class
probabilities include \code{knn}, \code{fil}, and \code{rand_forest}.
A warning message will be emitted if \code{output_class_probabilities}
is set to \code{TRUE} or \code{FALSE} but the model being applied does
not support class probabilities output.}

\item{...}{Additional arguments to \code{predict()}. Currently unused.}
}
\value{
Predictions on new data points.
}
\description{
Use a trained CuML model to make predictions on new data points.
Notice calling \code{cuml_predict()} will be identical to calling the
\code{predict()} S3 generic, except for \code{cuml_predict()} also comes
with proper documentation on all possible predict options (such as
\code{output_class_probabilities}) and will emit a sensible warning message
when a predict option is not applicable for a given model.
}
