% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{test}
\alias{test}
\title{Run Cucumber tests}
\usage{
test(
  path = "tests/acceptance",
  filter = NULL,
  reporter = NULL,
  env = NULL,
  load_helpers = TRUE,
  stop_on_failure = TRUE,
  stop_on_warning = FALSE,
  ...
)
}
\arguments{
\item{path}{Path to directory containing tests.}

\item{filter}{If not NULL, only features with file names matching this regular expression
will be executed. Matching is performed on the file name after it's stripped of ".feature".}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link[testthat]{Reporter} for more details and a list of built-in reporters.}

\item{env}{Environment in which to execute the tests. Expert use only.}

\item{load_helpers}{Source helper files before running the tests?}

\item{stop_on_failure}{If \code{TRUE}, throw an error if any tests fail.}

\item{stop_on_warning}{If \code{TRUE}, throw an error if any tests generate
warnings.}

\item{...}{Additional arguments passed to \code{\link[=grepl]{grepl()}} to control filtering.}
}
\description{
It runs tests from specifications in \code{.feature} files found in the \code{path}.
}
\section{Good Practices}{

\itemize{
\item Use a separate directory for your acceptance tests, e.g. \code{tests/acceptance}.

It's not prohibited to use \code{tests/testthat} directory, but it's not recommended as those tests
serve a different purpose and are usually run separately.
\item Use \href{https://testthat.r-lib.org/articles/special-files.html#setup-files}{\verb{setup-*.R}}
files for calling \code{\link[=step]{step()}}, \code{\link[=define_parameter_type]{define_parameter_type()}} and \code{\link[=hook]{hook()}} to leverage testthat loading mechanism.

If your \code{\link[=step]{step()}}, \code{\link[=define_parameter_type]{define_parameter_type()}} and \code{\link[=hook]{hook()}} are called from somewhere else, you are responsible for loading them.

Read more about testthat special files in the \href{https://testthat.r-lib.org/articles/special-files.html}{testthat documentation}.
\item Use \verb{test-*.R} files to test the support code you might have implemented that is used to run Cucumber tests.

Those tests won't be run when calling \code{\link[=test]{test()}}. To run those tests use
\code{testthat::test_dir("tests/acceptance")}.
}
}

\examples{
\dontrun{
cucumber::test("tests/acceptance")
cucumber::test("tests/acceptance", filter = "addition|multiplication")
}

}
