% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{slide_apply}
\alias{slide_apply}
\title{apply a cub index to a sliding window}
\usage{
slide_apply(seq, .f, step = 1, before = 0, after = 0, ...)
}
\arguments{
\item{seq}{DNAString, the sequence}

\item{.f}{function, the codon index calculation function to apply, for
example, \code{get_enc}.}

\item{step}{integer, the step size in number of codons}

\item{before}{integer, the number of codons before the center of a window}

\item{after}{integer, the number of codons after the center of a window}

\item{...}{additional arguments to pass to the function \code{.f}}
}
\value{
data.table with start, center, end, and codon usage index columns
}
\description{
\code{slide_apply} applies a function to a sliding window of codons.
}
\examples{
slide_apply(yeast_cds[[1]], get_enc, step = 1, before = 10, after = 10)

}
