% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pearson_measure.R
\encoding{UTF-8}
\name{pearson_measure}
\alias{pearson_measure}
\title{Computes the Pearson measure of a categorical time series}
\usage{
pearson_measure(series, lag = 1, categories, features = FALSE)
}
\arguments{
\item{series}{A CTS.}

\item{lag}{The considered lag (default is 1).}

\item{categories}{A vector of type factor containing the corresponding
categories.}

\item{features}{Logical. If \code{features = FALSE} (default), the value of the Pearson measure is returned. Otherwise, the function
returns a matrix with the individual components of the Pearson measure.}
}
\value{
If \code{features = FALSE} (default), returns the value of the Pearson measure. Otherwise, the function
returns a matrix of features, i.e., the matrix contains the features employed to compute the
Pearson measure.
}
\description{
\code{pearson_measure} returns the value of the Pearson measure for
a categorical time series
}
\details{
Given a CTS of length \eqn{T} with range \eqn{\mathcal{V}=\{1, 2, \ldots, r\}},
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
estimated Pearson measure, \eqn{\widehat{X}_T^2(l)=T\sum_{i,j=1}^{r}\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
where \eqn{\widehat{p}_i} is the natural estimate of the marginal probability of the \eqn{i}th
category, and \eqn{\widehat{p}_{ij}(l)} is the natural estimate of the joint probability
for categories \eqn{i} and \eqn{j} at lag l, \eqn{i,j=1, \ldots, r}. If \code{features = TRUE}, the function
returns a matrix whose components are the quantities \eqn{\frac{(\widehat{p}_{ij}(l)-\widehat{p}_i\widehat{p}_j)^2}{\widehat{p}_i\widehat{p}_j}},
\eqn{i,j=1,2, \ldots,r}.
}
\examples{
pm <- pearson_measure(series = SyntheticData1$data[[1]],
categories = factor(c(1, 2, 3))) # Computing the Pearson measure
# for the first series in dataset GeneticSequences
feature_matrix <- pearson_measure(series = SyntheticData1$data[[1]],
categories = factor(c(1, 2, 3)), features = TRUE) # Computing the corresponding
# matrix of features
}
\references{
{

  \insertRef{weiss2008measuring}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
