/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.SpatialIndex;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import com.vividsolutions.jts.index.chain.MonotoneChainSelectAction;
import com.vividsolutions.jts.index.strtree.STRtree;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.HotPixel;
import com.vividsolutions.jts.noding.snapround.SimpleSnapRounder;
import java.util.Collection;

public class MCIndexPointSnapper {
    public static int nSnaps = 0;
    private Collection monoChains;
    private STRtree index;

    public MCIndexPointSnapper(Collection monoChains, SpatialIndex index) {
        this.monoChains = monoChains;
        this.index = (STRtree)index;
    }

    public boolean snap(HotPixel hotPixel, SegmentString parentEdge, int vertexIndex) {
        final Envelope pixelEnv = hotPixel.getSafeEnvelope();
        final HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, vertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(){

            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(pixelEnv, hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public boolean snap(HotPixel hotPixel) {
        return this.snap(hotPixel, null, -1);
    }

    public class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        private HotPixel hotPixel;
        private SegmentString parentEdge;
        private int vertexIndex;
        private boolean isNodeAdded = false;

        public HotPixelSnapAction(HotPixel hotPixel, SegmentString parentEdge, int vertexIndex) {
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.vertexIndex = vertexIndex;
        }

        public boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        public void select(MonotoneChain mc, int startIndex) {
            SegmentString ss = (SegmentString)mc.getContext();
            if (this.parentEdge != null && ss == this.parentEdge && startIndex == this.vertexIndex) {
                return;
            }
            this.isNodeAdded = SimpleSnapRounder.addSnappedNode(this.hotPixel, ss, startIndex);
        }
    }
}

