## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(csdata)
library(data.table)
library(magrittr)
library(ggplot2)

## ----results='asis'-----------------------------------------------------------
pd <- csdata::nor_population_by_age_cats()[granularity_geo %in% "nation" & calyear>=1990]

q <- ggplot(pd, aes(x=calyear, y = pop_jan1_n))
q <- q + geom_line()
q <- q + geom_point(mapping = aes(color = imputed))
q <- q + scale_x_continuous("Calendar year (calyear)")
q <- q + scale_y_continuous("Population as of Jan 1 (pop_jan1_n)")
q <- q + scale_color_discrete("Imputed")
q <- q + labs(title = "Norway (nation_nor)")
q

## ----echo=FALSE, results='asis'-----------------------------------------------
d <- csdata::nor_population_by_age_cats()[csdata::nor_locations_names(),on="location_code"][granularity_geo %in% c("nation","county") & calyear>=2005]
setorder(d,location_order,calyear)
d[, location_name := factor(location_name, levels = unique(location_name))]
d <- d[,.(
  location_name, 
  calyear,
  pop_jan1_n = formatC(pop_jan1_n, big.mark=".", decimal.mark=",", format="f", digits=0)
)]

locations <- unique(d$location_name)

wd1 <- dcast.data.table(
  d[location_name %in% locations[1:8]],
  calyear ~ location_name,
  value.var = "pop_jan1_n"
)

wd2 <- dcast.data.table(
  d[location_name %in% locations[9:16]],
  calyear ~ location_name,
  value.var = "pop_jan1_n"
)

gt::gt(
  wd1,
  rowname_col = "calyear"
  ) %>%
  gt::tab_options(
    table.width = "300px"
  ) %>% 
  gt::tab_header(title = "Reference table of calyear and pop_jan1_n")

gt::gt(
  wd2,
  rowname_col = "calyear"
  ) %>%
  gt::tab_options(
    table.width = "300px"
  ) %>% 
  gt::tab_header(title = "Reference table of calyear and pop_jan1_n")

