% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amberdata.R
\name{amberdata_historical_exchange_volume}
\alias{amberdata_historical_exchange_volume}
\title{amberdata_historical_exchange_volume}
\usage{
amberdata_historical_exchange_volume(
  api_key,
  exchange = NULL,
  direction = NULL,
  start_date = NULL,
  end_date = NULL,
  time_format = NULL
)
}
\arguments{
\item{api_key}{your Amberdata API key}

\item{exchange}{the exchange you wish to retrieve volume for. By default this
function will return all exchange volume.}

\item{direction}{the direction in which to sort your results (by volume). The
default is descending order. This function will accept "desc" or "asc".}

\item{start_date}{only include data after this date (inclusive). This
parameter will accept dates formatted as seconds, milliseconds, or iso8601.}

\item{end_date}{only include data before this date (exclusive). The maximum
time range is 31 days. This parameter will accept dates formatted as seconds,
milliseconds, or iso8601.}

\item{time_format}{the format to return your times in. Choose from:
"milliseconds", "ms", "iso", "iso8601", "hr", and "human_readable". Default
is "ms".}
}
\value{
returns a dataframe with your volume data.
}
\description{
amberdata_historical_exchange_volume
}
\examples{
\dontrun{
api_key <- "..."
volume <- amberdata_historical_exchange_volume(api_key
                                               , "gdax"
                                               , "desc"
                                               , "2020-09-01T01:00:00"
                                               , "2020-09-02T01:00:00"
                                               , "hr")}
}
