% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crunchbox.R
\name{crunchBox}
\alias{crunchBox}
\title{Make a CrunchBox}
\usage{
crunchBox(dataset, filters = crunch::filters(dataset), brand_colors,
  static_colors, category_color_lookup, ...)
}
\arguments{
\item{dataset}{A CrunchDataset, potentially a selection of variables from it}

\item{filters}{FilterCatalog, or \code{NULL} for no filters. Default all
filters in your catalog, \code{filters(dataset)}.}

\item{brand_colors}{an optional color vector of length 3 or less, or a named
list with names 'primary', 'secondary', and 'message'. See "Details" for more
about color specification.}

\item{static_colors}{an optional vector of colors to use for categorical
plots. Bars and lines are colored in the order of \code{static_colors}. See
"Details" for more about color specification.}

\item{category_color_lookup}{an optional list of category names to colors
to use for that category, wherever it appears in the data. This allows you
to always see a category displayed in a specific color. See
"Details" for more about color specification.}

\item{...}{additional metadata for the box, such as "title", "header", etc.}
}
\value{
The URL to the newly created box.
}
\description{
CrunchBoxes allow you to publish results to the world.
}
\details{
In addition to specifying the variables and filters to include in your
CrunchBox, you can provide custom color palettes. The arguments
\code{brand_colors}, \code{static_colors}, and \code{category_color_lookup} allow you to
provide color lists to use. Colors should be either a valid hexadecimal
string representation, like "#fa1af1", or they may also be an R named color,
such as "darkgreen".
}
\examples{

\dontrun{
# Creating a CrunchBox with three variables
crunchBox(ds[c("var1", "var2", "var3")], title="New CrunchBox")

# Creating a CrunchBox changing primary, secondary, and message brand colors
crunchBox(ds[c("var1", "var2", "var3")],
          title="Branded CrunchBox",
          brand_colors = c("#ff0aa4", "#af17ff", "#260aff"))

# Creating a CrunchBox changing category-specific colors
crunchBox(ds[c("var1", "var2", "var3")],
          title="CrunchBox with category colors",
          category_color_lookup = list("agree" = "#ff0aa4",
                                       "disagree" = "#af17ff",
                                       "don't know" = "#260aff"))
}

}
\seealso{
\code{\link{preCrunchBoxCheck}} to provide guidance on what you're including in the
}
