% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-headers.R
\name{http-headers}
\alias{http-headers}
\title{Working with HTTP headers}
\description{
Working with HTTP headers
}
\examples{
\dontrun{
(x <- HttpClient$new(url = "https://httpbin.org"))

# set headers
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE
  ),
  headers = list(
    a = "stuff",
    b = "things"
  )
))
res$headers
# reassign header value
res$headers$a <- "that"
# define new header
res$headers$c <- "what"
# request
res$get('get')

## setting content-type via headers
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE
  ),
  headers = list(`Content-Type` = "application/json")
))
res$get('get')
}
}
