% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_space.R
\name{structure_gauss}
\alias{structure_gauss}
\title{Structure of gaussian atoms}
\usage{
structure_gauss(sdata, x = NULL, N = NULL, k = ksigma)
}
\arguments{
\item{sdata}{A named list, normally obtained through the use of
function \code{\link{read_x}} or \code{\link{standardise_sdata}}. 
The list names correspond to  different object types:
\itemize{
  \item{a.     Real numeric. The size of the unit cell.}
  \item{SG.    Character string. Space group symbol; either "P1" 
               or "P-1"}
  \item{x0.    Vector of real numerics indicating the expanded atomic
               positions in the unit cell.}
  \item{Z.     Vector of integers indicating the expanded 
               atomic numbers for all atoms in the unit cell.}
  \item{B.    Vector of real numerics indicating the expanded 
              B factors for all atoms in the unit cell.}
  \item{occ.  Vector of real numerics indicating the expanded 
              occupancies for all atoms in the unit cell.}
}}

\item{x}{Point in the 1D cell at which this function is calculated.
Default is NULL, in which case a grid is set up internally.}

\item{N}{Integer. Number of points in the regular grid, if the grid
is not provided directly.}

\item{k}{A real number. It controls the standard deviation of the 
gaussian function describing the atom and, thus, the shape of the
associated peak. The standard deviation sigma is given by:
         \code{sigma = k * sqrt(Z)}}
}
\value{
A named list of length 2: x is the grid (either input by
 user or set up internally), rr is a vector of length equal to the 
 length of vector x, with values equal to the evaluated gaussian atoms.
}
\description{
Structure formed by all gaussian atoms in the unit cell. Positions, 
atomic numbers and thermal factors are given by vectors of a same 
length. Each atom forming the structure is also characterised by a given 
occupancy (between 0 and 1).
}
\examples{
# Cell, atom types, positions and B factors
a <- 10
SG <- "P1"
x0 <- c(2,5,7)
Z <- c(6,16,8)
B <- c(0,0,0)

# All occupancies to 1
occ <- c(1,1,1)

# Standard data format
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)

# Grid for unit cell
x <- seq(0,a,length=1000)

# Structure density
rtmp <- structure_gauss(sdata,x)
plot(rtmp$x,rtmp$rr,type="l",xlab="x",ylab=expression(rho))

# Now reduce occupancy of sulphur
occ[2] <- 0.5
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)
rtmp <- structure_gauss(sdata,x)
points(rtmp$x,rtmp$rr,type="l",col=2)

# Increase temperature of oxygen
B[3] <- 10
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)
rtmp <- structure_gauss(sdata,x)
points(rtmp$x,rtmp$rr,type="l",col=3)

}
