% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-validity.R
\name{v_increments}
\alias{v_increments}
\alias{v_increments_relative}
\alias{v_increments_relative_parts}
\alias{v_increments_relative_dlt}
\alias{v_increments_dose_levels}
\alias{v_increments_hsr_beta}
\alias{v_increments_min}
\alias{v_increments_maxtoxprob}
\alias{v_increments_ordinal}
\alias{v_cohort_size_ordinal}
\title{Internal Helper Functions for Validation of \code{\link{Increments}} Objects}
\usage{
v_increments_relative(object)

v_increments_relative_parts(object)

v_increments_relative_dlt(object)

v_increments_dose_levels(object)

v_increments_hsr_beta(object)

v_increments_min(object)

v_increments_maxtoxprob(object)

v_increments_ordinal(object)

v_cohort_size_ordinal(object)
}
\arguments{
\item{object}{(\code{Increments})\cr object to validate.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{Increments}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_increments_relative()}: validates that the \code{\link{IncrementsRelative}} object
contains valid \code{intervals} and \code{increments} parameters.

\item \code{v_increments_relative_parts()}: validates that the \code{\link{IncrementsRelativeParts}} object
contains valid \code{dlt_start} and \code{clean_start} parameters.

\item \code{v_increments_relative_dlt()}: validates that the \code{\link{IncrementsRelativeDLT}} object
contains valid \code{intervals} and \code{increments} parameters.

\item \code{v_increments_dose_levels()}: validates that the \code{\link{IncrementsDoseLevels}} object
contains valid \code{levels} and \code{basis_level} option.

\item \code{v_increments_hsr_beta()}: validates that the \code{\link{IncrementsHSRBeta}}
object contains valid probability target, threshold and shape parameters.

\item \code{v_increments_min()}: validates that the \code{\link{IncrementsMin}}
object contains a list with \code{Increments} objects.

\item \code{v_increments_maxtoxprob()}: validates the \code{\link{IncrementsMaxToxProb}}

\item \code{v_increments_ordinal()}: validates that the \code{\link{IncrementsOrdinal}} object
contains valid \code{grade} and standard \code{Increments} rule.

\item \code{v_cohort_size_ordinal()}: validates that the \code{\link{CohortSizeOrdinal}} object
contains valid \code{grade} and standard \code{CohortSize} rule.

}}
