% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rules-class.R
\docType{class}
\name{NextBestDualEndpoint-class}
\alias{NextBestDualEndpoint-class}
\alias{.NextBestDualEndpoint}
\alias{NextBestDualEndpoint}
\alias{.DefaultNextBestDualEndpoint}
\title{\code{NextBestDualEndpoint}}
\usage{
NextBestDualEndpoint(
  target,
  overdose,
  max_overdose_prob,
  target_relative = TRUE,
  target_thresh = 0.01
)

.DefaultNextBestDualEndpoint()
}
\arguments{
\item{target}{(\code{numeric})\cr see slot definition.}

\item{overdose}{(\code{numeric})\cr see slot definition.}

\item{max_overdose_prob}{(\code{proportion})\cr see slot definition.}

\item{target_relative}{(\code{flag})\cr see slot definition.}

\item{target_thresh}{(\code{proportion})\cr see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link{NextBestDualEndpoint}} is the class for next best dose that is based on the
dual endpoint model.
}
\details{
Under this rule, at first admissible doses are found, which are those
with toxicity probability to fall in \code{overdose} category and being below
\code{max_overdose_prob}. Next, it picks (from the remaining admissible doses) the
one that maximizes the probability to be in the \code{target} biomarker range. By
default (\code{target_relative = TRUE}) the target is specified as relative to the
maximum biomarker level across the dose grid or relative to the \code{Emax}
parameter in case a parametric model was selected (i.e. \code{\link{DualEndpointBeta}},
\code{\link{DualEndpointEmax}}). However, if \code{target_relative = FALSE}, then the
absolute biomarker range can be used as a target.
}
\section{Slots}{

\describe{
\item{\code{target}}{(\code{numeric})\cr the biomarker target range that needs to be
reached. For example, the target range \eqn{(0.8, 1.0)} and
\code{target_relative = TRUE} means that we target a dose with at least
\eqn{80\%} of maximum biomarker level. As an other example,
\eqn{(0.5, 0.8)} would mean that we target a dose between \eqn{50\%} and
\eqn{80\%} of the maximum biomarker level.}

\item{\code{overdose}}{(\code{numeric})\cr the overdose toxicity interval (lower limit
excluded, upper limit included).}

\item{\code{max_overdose_prob}}{(\code{proportion})\cr maximum overdose probability that
is allowed.}

\item{\code{target_relative}}{(\code{flag})\cr is \code{target} specified as relative? If
\code{TRUE}, then the \code{target} is interpreted relative to the maximum, so it
must be a probability range. Otherwise, the \code{target} is interpreted as
absolute biomarker range.}

\item{\code{target_thresh}}{(\code{proportion})\cr a target probability threshold that
needs to be fulfilled before the target probability will be used for
deriving the next best dose (default to 0.01).}
}}

\note{
Typically, end users will not use the \code{.DefaultNextBestDualEndpoint()} function.
}
\examples{
# Target a dose achieving at least 0.9 of maximum biomarker level (efficacy)
# and with a probability below 0.25 that prob(DLT) > 0.35 (safety).
my_next_best <- NextBestDualEndpoint(
  target = c(0.9, 1),
  overdose = c(0.35, 1),
  max_overdose_prob = 0.25
)

# Now, using absolute target on the natural biomarker scale.
my_next_best_absolute <- NextBestDualEndpoint(
  target = c(200, 300),
  overdose = c(0.35, 1),
  max_overdose_prob = 0.25,
  target_relative = FALSE
)
}
