% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_rules.R
\name{h_next_best_ncrm_loss_plot}
\alias{h_next_best_ncrm_loss_plot}
\title{Building the Plot for \code{nextBest-NextBestNCRMLoss} Method.}
\usage{
h_next_best_ncrm_loss_plot(
  prob_mat,
  posterior_loss,
  max_overdose_prob,
  dose_grid,
  max_eligible_dose_level,
  doselimit,
  next_dose,
  is_unacceptable_specified
)
}
\arguments{
\item{prob_mat}{(\code{numeric})\cr matrix with probabilities of a grid doses
to be in a given interval. If \code{is_unacceptable_specified} is \code{TRUE}, there
must be 4 intervals (columns) in \code{prob_mat}: \code{underdosing}, \code{target},
\code{excessive}, \code{unacceptable}. Otherwise, there must be 3 intervals (columns):
\code{underdosing}, \code{target}, \code{overdose}. Number of rows must be equal to number
of doses in a grid.}

\item{posterior_loss}{(\code{numeric})\cr posterior losses.}

\item{max_overdose_prob}{(\code{number})\cr maximum overdose posterior
probability that is allowed.}

\item{dose_grid}{(\code{numeric})\cr dose grid.}

\item{max_eligible_dose_level}{(\code{number})\cr maximum eligible dose level in
the \code{dose_grid}.}

\item{doselimit}{(\code{number})\cr the maximum allowed next dose.}

\item{next_dose}{(\code{number})\cr next best dose.}

\item{is_unacceptable_specified}{(\code{flag})\cr is unacceptable interval specified?}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Helper function which creates the plot for \code{\link[=nextBest-NextBestNCRMLoss]{nextBest-NextBestNCRMLoss()}}
method.
}
