% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_client.R
\name{crew_class_client}
\alias{crew_class_client}
\title{\code{R6} client class.}
\description{
\code{R6} class for \code{mirai} clients.
}
\details{
See \code{\link[=crew_client]{crew_client()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}

## ------------------------------------------------
## Method `crew_class_client$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}
}
\seealso{
Other client: 
\code{\link{crew_client}()}
}
\concept{client}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{host}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{port}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{serialization}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_client]{crew_client()}}.}

\item{\code{relay}}{Relay object for event-driven programming on a downstream
condition variable.}

\item{\code{started}}{Whether the client is started.}

\item{\code{url}}{Client websocket URL.}

\item{\code{profile}}{Compute profile of the client.}

\item{\code{condition}}{Condition variable of the client.}

\item{\code{client}}{Process ID of the local process running the client.}

\item{\code{dispatcher}}{Process ID of the \code{mirai} dispatcher}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_client-new}{\code{crew_class_client$new()}}
\item \href{#method-crew_class_client-validate}{\code{crew_class_client$validate()}}
\item \href{#method-crew_class_client-set_started}{\code{crew_class_client$set_started()}}
\item \href{#method-crew_class_client-start}{\code{crew_class_client$start()}}
\item \href{#method-crew_class_client-terminate}{\code{crew_class_client$terminate()}}
\item \href{#method-crew_class_client-resolved}{\code{crew_class_client$resolved()}}
\item \href{#method-crew_class_client-status}{\code{crew_class_client$status()}}
\item \href{#method-crew_class_client-pids}{\code{crew_class_client$pids()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} client constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$new(
  host = NULL,
  port = NULL,
  tls = NULL,
  serialization = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  relay = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{port}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{tls}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{serialization}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_interval}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{seconds_timeout}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}

\item{\code{relay}}{Argument passed from \code{\link[=crew_client]{crew_client()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the client.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
client$start()
client$log()
client$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-set_started"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-set_started}{}}}
\subsection{Method \code{set_started()}}{
Register the client as started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$set_started()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Exported to implement the sequential controller.
Only meant to be called manually inside the client or
the sequential controller.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-start}{}}}
\subsection{Method \code{start()}}{
Start listening for workers on the available sockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$start()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-terminate}{}}}
\subsection{Method \code{terminate()}}{
Stop the mirai client and disconnect from the
worker websockets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-resolved"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-resolved}{}}}
\subsection{Method \code{resolved()}}{
Get the true value of the \code{nanonext} condition variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$resolved()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The value of the \code{nanonext} condition variable.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-status"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-status}{}}}
\subsection{Method \code{status()}}{
Internal function:
return the \code{mirai} status of the compute profile.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$status()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Should only be called by the launcher, never by the user.
The returned \code{events} field changes on every call and must be
interpreted by the launcher before it vanishes.
}

\subsection{Returns}{
A list with status information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_client-pids"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_client-pids}{}}}
\subsection{Method \code{pids()}}{
Get the process IDs of the local process and the
\code{mirai} dispatcher (if started).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_client$pids()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer vector of process IDs of the local process and the
\code{mirai} dispatcher (if started).
}
}
}
