% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_assert.R
\name{crew_assert}
\alias{crew_assert}
\title{Crew assertion}
\usage{
crew_assert(value = NULL, ..., message = NULL, envir = parent.frame())
}
\arguments{
\item{value}{An object or condition.}

\item{...}{Conditions that use the \code{"."} symbol to refer to the object.}

\item{message}{Optional message to print on error.}

\item{envir}{Environment to evaluate the condition.}
}
\value{
\code{NULL} (invisibly). Throws an error if the condition is not true.
}
\description{
Assert that a condition is true.
}
\examples{
crew_assert(1 < 2)
crew_assert("object", !anyNA(.), nzchar(.))
tryCatch(
  crew_assert(2 < 1),
  crew_error = function(condition) message("false")
)
}
\seealso{
Other utility: 
\code{\link{crew_clean}()},
\code{\link{crew_deprecate}()},
\code{\link{crew_eval}()},
\code{\link{crew_random_name}()},
\code{\link{crew_retry}()},
\code{\link{crew_worker}()}
}
\concept{utility}
