% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/essential_algorithms.R
\name{char_cor_vars}
\alias{char_cor_vars}
\alias{char_cor}
\title{Cramer's V matrix between categorical variables.}
\usage{
char_cor_vars(dat, x)

char_cor(dat, x_list = NULL, ex_cols = "date$", parallel = FALSE, note = FALSE)
}
\arguments{
\item{dat}{A data frame.}

\item{x}{The name of variable to process.}

\item{x_list}{Names of independent variables.}

\item{ex_cols}{A list of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{parallel}{Logical, parallel computing. Default is FALSE.}

\item{note}{Logical. Outputs info. Default is TRUE.}
}
\value{
A list contains correlation index of x with other variables in dat.
}
\description{
\code{char_cor_vars} is function for calculating Cramer's V matrix between categorical variables.
\code{char_cor} is function for calculating the correlation coefficient between variables by cremers 'V
}
\examples{
\dontrun{
char_x_list = get_names(dat = UCICreditCard,
types = c('factor', 'character'),
ex_cols = "ID$|date$|default.payment.next.month$", get_ex = FALSE)
 char_cor(dat = UCICreditCard[char_x_list])
}
}
