% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranlike.R
\name{update_PACKAGES}
\alias{update_PACKAGES}
\title{Create or update PACKAGES* files for a CRAN-like repository}
\usage{
update_PACKAGES(dir = ".", fields = NULL, type = c("source", "mac.binary",
  "win.binary"))
}
\arguments{
\item{dir}{Character vector describing the location of the repository
    (directory including source or binary packages) to generate the
    \file{PACKAGES}, \file{PACKAGES.gz} and \file{PACKAGES.rds} files
    from and write them to.
  }

\item{fields}{
    a character vector giving the fields to be used in the
    \file{PACKAGES}, \file{PACKAGES.gz} and \file{PACKAGES.rds} files in
    addition to the default ones, or \code{NULL} (default).

    The default corresponds to
    the fields needed by \code{\link{available.packages}}:
    \code{"Package"}, \code{"Version"}, \code{"Priority"},
    \code{"Depends"}, \code{"Imports"}, \code{"LinkingTo"},
    \code{"Suggests"}, \code{"Enhances"}, \code{"OS_type"},
    \code{"License"} and \code{"Archs"}, and those fields will always
    be included, plus
    the file name in field \code{"File"} if \code{addFile = TRUE}
    and the path to the subdirectory in field \code{"Path"} if subdirectories
    are used.
  }

\item{type}{
    Type of packages: currently source \file{.tar.{gz,bz2,xz}} archives,
    and macOS or Windows binary (\file{.tgz} or \file{.zip},
    respectively) packages are supported.  Defaults to
    \code{"win.binary"} on Windows and to \code{"source"} otherwise.
  }
}
\description{
This function is similar to \code{\link[tools:write_PACKAGES]{tools::write_PACKAGES()}}, with some
differences:
\itemize{
\item It always uses the \code{MD5sum} field.
\item It defaults to \code{addFiles = TRUE}, to allow following the package
files better.
\item It does not support the \code{verbose}, \code{unpacked}, and \code{subdirs}
arguments currently.
\item It uses a database to speed up the indexing process, and only
reindexes files that have added, removed or updated.
}
}
\details{
\code{update_PACKAGES} uses a SQLite database to aid updating PACKAGES*
files quickly. It this database does not exist, then it will be created
based on the existing PACKAGES* files. If no PACKAGES* files exist,
either, then these will be created via \code{tools::write_PACKAGES()}.
}
\seealso{
Other PACKAGES manipulation: \code{\link{add_PACKAGES}},
  \code{\link{remove_PACKAGES}}
}
