% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{obtain_u_set_mix3}
\alias{obtain_u_set_mix3}
\title{Obtain set of thresholds with high posterior density for the 3-component mixture model}
\usage{
obtain_u_set_mix3(
  df,
  powerlaw1 = FALSE,
  powerlaw2 = FALSE,
  positive1 = FALSE,
  positive2 = TRUE,
  name = TRUE,
  log_diff_max = 11,
  v_max = 100L,
  u_max = 2000L,
  alpha_init = 0.01,
  theta_init = exp(-1),
  shape_init = 1,
  sigma_init = 1,
  a_psi1 = 1,
  a_psi2 = 1,
  a_psiu = 0.001,
  b_psiu = 0.9,
  m_alpha = 0,
  s_alpha = 10,
  a_theta = 1,
  b_theta = 1,
  m_shape = 0,
  s_shape = 10,
  a_sigma = 1,
  b_sigma = 0.01
)
}
\arguments{
\item{df}{A data frame with at least two columns, degree & count}

\item{powerlaw1}{Boolean, is the power law (TRUE) or polylogarithm (FALSE, default) assumed for the left tail?}

\item{powerlaw2}{Boolean, is the power law (TRUE) or polylogarithm (FALSE, default) assumed for the middle bulk?}

\item{positive1}{Boolean, is alpha positive (TRUE) or unbounded (FALSE, default) for the left tail?}

\item{positive2}{Boolean, is alpha positive (TRUE) or unbounded (FALSE, default) for the middle bulk?}

\item{name}{Boolean; if the column \code{name} exists, are its unique values printed?}

\item{log_diff_max}{Positive real number, the value such that thresholds with profile posterior density not less than the maximum posterior density - \code{log_diff_max} will be kept}

\item{v_max}{Positive integer for the maximum lower threshold}

\item{u_max}{Positive integer for the maximum upper threshold}

\item{alpha_init}{Scalar, initial value of alpha}

\item{theta_init}{Scalar, initial value of theta}

\item{shape_init}{Scalar, initial value of shape parameter}

\item{sigma_init}{Scalar, initial value of sigma}

\item{a_psi1, a_psi2, a_psiu, b_psiu, m_alpha, s_alpha, a_theta, b_theta, m_shape, s_shape, a_sigma, b_sigma}{Scalars, hyperparameters of the priors for the parameters}
}
\value{
A list: \code{v_set} is the vector of lower thresholds with high posterior density, \code{u_set} is the vector of upper thresholds with high posterior density, \code{init} is the data frame with the maximum profile posterior density and associated parameter values, \code{profile} is the data frame with all thresholds with high posterior density and associated parameter values, \code{scalars} is the data frame with all arguments (except df)
}
\description{
\code{obtain_u_set_mix3} computes the profile posterior density of the thresholds v & u, and subsets the thresholds (and other parameter values) with high profile values i.e. within a certain value from the maximum posterior density. The sets of v & u can then be used for \code{\link{mcmc_mix3}}.
}
\seealso{
\code{\link{mcmc_mix3_wrapper}} that wraps \code{obtain_u_set_mix3} and \code{\link{mcmc_mix3}}
}
