#' cpss: Change-Point Detection by Sample-Splitting Methods
#'
#' Implements multiple change searching algorithms for a variety of frequently considered parametric change-point models. In particular, it integrates a criterion proposed by Zou, Wang and Li (2020) <doi:10.1214/19-AOS1814> to select the number of change-points in a data-driven fashion. Moreover, it also provides interfaces for user-customized change-point models with one's own cost function and parameter estimation routine.
#'
#' @section Getting started:
#' Easy to get started with the cpss.* set of functions by accessing their  documentation pages\cr
#' library(cpss)\cr
#' ?cpss.mean\cr
#' ?cpss.var\cr
#' ?cpss.meanvar\cr
#' ?cpss.glm\cr
#' ?cpss.lm\cr
#' ?cpss.em\cr
#' ?cpss.custom
#'
#' @docType package
#' @name cpss
NULL
#> NULL
