% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpop.R
\name{residuals}
\alias{residuals}
\alias{residuals,cpop.class-method}
\title{Extract residuals from a cpop model}
\usage{
\S4method{residuals}{cpop.class}(object)
}
\arguments{
\item{object}{An instance of an S4 class produced by \code{\link{cpop}}.}
}
\value{
A single column matrix containing the residuals.
}
\description{
Extracts residuals from a cpop model.
}
\examples{
library(cpop)

# simulate data with change in gradient
set.seed(1)
x <- (1:50/5)^2
y <- simchangeslope(x,changepoints=c(10,50),change.slope=c(0.25,-0.25),sd=1)

# determine changepoints
res <- cpop(y,x,beta=2*log(length(y)))

# calculate the residuals
residuals(res)

}
\references{
\insertRef{cpop-jss-article-2024}{cpop}
}
