% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmhist.R
\name{cmhist}
\alias{cmhist}
\title{Multi-class Stacked Circular Histogram and Rose Diagram}
\usage{
cmhist(value, class, nbins = 36, radius = 1/sqrt(base::pi),
  area.prop = TRUE, prob = TRUE, proportion = FALSE,
  total.area = 1, nlabels = 4, cols = NULL, borders = NULL,
  m = NA, xlim = NULL, ylim = NULL, main = NULL, type = c("null",
  "compass", "clock"), x.legend = "bottomright", y.legend = NULL)
}
\arguments{
\item{value}{a numeric vector storing angular values between 0 and 2 pi,
or an object that can be coerced to.}

\item{class}{a character vector specifying the group the \code{value}
belongs to. It needs to have the same length as \code{value},
otherwise it is repeated to the length of \code{value}. The order of
plotting from the innermost to the outermost depends on the order of
their appearance in \code{class}.}

\item{nbins}{the number of bins of the circular histogram. Internally,
it is rounded to a multiple of 4.}

\item{radius}{the radius of the reference circle.  If \code{radius = 0},
a rose diagram is produced; if \code{radius > 0}, a circular histogram
is produced outside the reference circle.}

\item{area.prop}{logical; if \code{TRUE}, an area-proportional
transformation is applied; if \code{FALSE}, a height-proportional
transformationis applied.}

\item{prob}{logical; if \code{TRUE}, the circular histogram graphic is a
representation of probability densities; if \code{FALSE}, a
representation of frequencies.}

\item{proportion}{logical; if \code{TRUE}, the frequencies are scaled by
the proportion of each class, so that the total area under bars is
unity; if \code{FALSE}, each class is considered as a separate
distribution and has area of unity.}

\item{total.area}{a positive number specifying the total area under all the
histograms. If \code{total.area = NULL}, no scaling is applied, the
plot is in the original scale. If \code{area.prop = TRUE}, the total area 
is automatically unity without scaling.}

\item{nlabels}{integer, for the number of levels to be plotted; if
\code{0}, no label is plotted.  The larger the number is, the more
accurate the plot will be.}

\item{cols}{the colors to fill the bars, with the same order as the
class.}

\item{borders}{the colors of the border around the bars.}

\item{m}{the number of points within each bin to plot the circular
histogram. The larger the number is, the smoother the plot looks.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates
ranges.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates
ranges.}

\item{main}{the main title (on top)}

\item{type}{the type of circular data, one of the values \code{"null"},
\code{"compass"} or \code{"clock"}.  If \code{"null"}, no special
lables plotted for directions. If \code{"compass"}, the four cardinal
directions are printed inside the reference circle. If \code{"clock"},
labels for 24 hours are printed inside the reference circle.}

\item{x.legend}{x coordinate to plot the legend.}

\item{y.legend}{y coordinate to plot the legend.}
}
\description{
Function \code{cmhist} can be used to plot 2-dimensional 
  histograms and rose diagrams for circular data with multiple classes. 
  The histograms are stacked to avoid any overlap.
}
\examples{
# Load the dataset
library(circular)
data("pigeons", package = "circular")
x = pigeons[,2] / 180 * pi
y = pigeons[,1]

# stacked circular histograms
cmhist(x, y)             # area-proportional 
cmhist(x, y, area=FALSE) # height-proportional

}
\references{
Xu, D. and Wang, Y. (2019) Area-proportional Visualization for 
  Circular Data (submitted).
}
\seealso{
\code{\link{chist}}, \code{\link{cmdensity}}
}
\author{
Danli Xu <dxu452@aucklanduni.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}
\keyword{circular}
\keyword{histogram}
\keyword{multi-class}
\keyword{stacked}
