% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aut(mrc).R
\name{mrc.mean}
\alias{mrc.mean}
\title{Segmenting data generated from AR1.data/MA1.data using PELT funtion.}
\usage{
mrc.mean(data, beta = 1.5 * log(n))
}
\arguments{
\item{data}{a censored data matrix obtained from AR1.data/
MA1.data .}

\item{beta}{default 1.5*log(n).}
}
\value{
data
}
\description{
To find changepoints using mrc method, segmenting
the data (obtained from AR1.data/MA1.data) using PELT (Killick, Fearnhead
and Eckley 2012) function in such a way
that cost is minimum .
}
\examples{
#example(right censoring)
library(cpcens)
n=500
N=100
# Generate censored data using AR model
# The size of series(n) should be greater than 200.
sim=AR1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.4, mu = 0, siga = 1, rates = c(NA, 0.4), Mrate = 0)
data=sim$data
mrc = mrc.mean( data , beta = 1.5*log(n) )
mrc
#example(left censoring)
library(cpcens)
n=500
N=100
# Generate censored data using MA model
# The size of series(n) should be greater than 200.
sim=MA1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.4, mu = 0, siga = 1, rates = c(0.6,NA), Mrate = 0)
data=sim$data
mrc = mrc.mean( data , beta = 1.5*log(n) )
mrc
}
\references{
Killick, R., Fearnhead, P., and Eckley, I. A. (2012). Optimal detection of changepoints
with a linear computational cost. Journal of the American Statistical Association,
107(500):1590–1598.
}
\seealso{
AR1.data, MA1.data
}
