% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcbs(AR).R
\name{Bin_segAR}
\alias{Bin_segAR}
\title{Most recent changepoints from dcbs method using censored AR timeseries.}
\usage{
Bin_segAR(data, beta = 10)
}
\arguments{
\item{data}{a censored data matrix obtained from AR1.data.}

\item{beta}{threshold for testing whether or not a change is
significant, default 10.}
}
\value{
indicates the most recent changepoint in each series.
}
\description{
Detecting most recent changepoints from double CUSUM
binary segmentation (DCBS) method (Cho, 2016) after
generating censored data from AR model. The DCBS method focuses on finding the position of detected
changepoints. The consistency of the double CUSUM statistic based on the
binary segmentation algorithm that is established in terms of both number
and locations of estimated changepoints.
}
\examples{
library(cpcens)
#example(right censoring)
# The length of series(n) should be greater than 200.
sim=AR1.data(n = 500, N = 100, K = 5, eps = 1,
rho = 0.4, mu = 0, siga = 1, rates = c(NA, 0.4), Mrate = 0)
data=sim$data
ans = Bin_segAR(data,beta=10)
}
\seealso{
AR1.data
}
