% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_national_data.R
\name{get_national_data}
\alias{get_national_data}
\title{Get national-level data for countries globally from a range of sources}
\usage{
get_national_data(
  countries,
  source = "who",
  level = "1",
  totals = FALSE,
  steps = FALSE,
  class = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{countries}{A character vector specifying country names of interest.
Used to filter the data.}

\item{source}{A character string specifying the data source (not case
dependent). Defaults to WHO (the World Health Organisation). See
\code{get_available_datasets("national")} for all options.}

\item{level}{A character string indicating the target administrative level
of the data with the default being "1". Currently supported options are
level 1 ("1) and level 2 ("2"). Use \code{get_available_datasets()} for supported
options by dataset.}

\item{totals}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{steps}{Logical, defaults to FALSE. Should all processing and cleaning
steps be kept and output in a list.}

\item{class}{Logical, defaults to FALSE. If TRUE returns the
\code{DataClass} object rather than a tibble or a list of tibbles.
Overrides \code{steps}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{...}{Additional arguments to pass to class specific functionality.}
}
\value{
A tibble with data related to cases, deaths, hospitalisations,
recoveries and testing.
}
\description{
Provides an interface to source specific classes which
support national level data. For simple use cases this allows downloading
clean, standardised, national-level COVID-19 data sets. Internally this uses
the \code{CountryDataClass()} parent class which allows documented downloading,
cleaning, and processing. Optionally all steps of data processing can be
returned along with the functions used for processing but by default just
the finalised processed data is returned. See the examples for some
potential use cases and the links to lower level functions for more details
and options.
}
\examples{
\dontrun{
# set up a data cache
start_using_memoise()

# download all national data from the WHO
get_national_data(source = "who")

# download data for Canada keeping all processing steps
get_national_data(countries = "canada", source = "ecdc")

# download data for Canada from the JHU and return the full class
jhu <- get_national_data(countries = "canada", source = "jhu", class = TRUE)
jhu

# return the JHU data for canada
jhu$return()

# check which regions the JHU supports national data for
jhu$available_regions()

# filter instead for France (and then reprocess)
jhu$filter("France")
jhu$process()

# explore the structure of the stored JHU data
jhu$data
}
}
\seealso{
\code{\link[=WHO]{WHO()}}, \code{\link[=ECDC]{ECDC()}}, \code{\link[=JHU]{JHU()}}, \code{\link[=Google]{Google()}}

Data interface functions
\code{\link{CountryDataClass}},
\code{\link{DataClass}},
\code{\link{get_available_datasets}()},
\code{\link{get_regional_data}()},
\code{\link{initialise_dataclass}()}
}
\concept{interface}
