% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lap_solve.R
\name{assignment_duals}
\alias{assignment_duals}
\title{Solve assignment problem and return dual variables}
\usage{
assignment_duals(cost, maximize = FALSE)
}
\arguments{
\item{cost}{Numeric matrix; rows = tasks, columns = agents. \code{NA} or \code{Inf}
entries are treated as forbidden assignments.}

\item{maximize}{Logical; if \code{TRUE}, maximizes the total cost instead of minimizing.}
}
\value{
A list with class \code{"assignment_duals_result"} containing:
\itemize{
\item \code{match} - integer vector of column assignments (1-based)
\item \code{total_cost} - optimal objective value
\item \code{u} - numeric vector of row dual variables (length n)
\item \code{v} - numeric vector of column dual variables (length m)
\item \code{status} - character, e.g. "optimal"
}
}
\description{
Solves the linear assignment problem and returns dual potentials (u, v)
in addition to the optimal matching. The dual variables provide an
optimality certificate and enable sensitivity analysis.
}
\details{
The dual variables satisfy the complementary slackness conditions:
\itemize{
\item For minimization: \code{u[i] + v[j] <= cost[i,j]} for all (i,j)
\item For any assigned pair (i,j): \code{u[i] + v[j] = cost[i,j]}
}

This implies that \code{sum(u) + sum(v) = total_cost} (strong duality).

\strong{Applications of dual variables:}
\itemize{
\item \strong{Optimality verification}: Check that duals satisfy constraints
\item \strong{Sensitivity analysis}: Reduced cost \code{c[i,j] - u[i] - v[j]} shows
how much an edge cost must decrease before it enters the solution
\item \strong{Pricing in column generation}: Use duals to price new columns
\item \strong{Warm starting}: Reuse duals when costs change slightly
}
}
\examples{
cost <- matrix(c(4, 2, 5, 3, 3, 6, 7, 5, 4), nrow = 3, byrow = TRUE)
result <- assignment_duals(cost)

# Check optimality: u + v should equal cost for assigned pairs
for (i in 1:3) {
  j <- result$match[i]
  cat(sprintf("Row \%d -> Col \%d: u + v = \%.2f, cost = \%.2f\n",
              i, j, result$u[i] + result$v[j], cost[i, j]))
}

# Verify strong duality
cat("sum(u) + sum(v) =", sum(result$u) + sum(result$v), "\n")
cat("total_cost =", result$total_cost, "\n")

# Reduced costs (how much must cost decrease to enter solution)
reduced <- outer(result$u, result$v, "+")
reduced_cost <- cost - reduced
print(round(reduced_cost, 2))

}
\seealso{
\code{\link[=assignment]{assignment()}} for standard assignment without duals
}
