% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportionality.R
\name{naiveVariation}
\alias{naiveVariation}
\title{Naive (Empirical) Variation}
\usage{
naiveVariation(
  counts,
  pseudo.count = 0,
  type = c("standard", "phi", "phis", "rho", "logp"),
  impute.zeros = TRUE,
  ...
)
}
\arguments{
\item{counts}{Matrix of counts; samples are rows and features are columns}

\item{pseudo.count}{Positive count to be added to all elements of count matrix.}

\item{type}{Type of variation metric to be calculated: \code{standard}, \code{phi},
\code{phis} (a symmetric version of \code{phi}), \code{rho}, or \code{logp} (the variance-covariance matrix of log-transformed proportions)}

\item{impute.zeros}{If TRUE, then \code{cmultRepl()} from the \code{zCompositions} package is used to impute zero values in the counts matrix.}

\item{...}{Optional arguments passed to zero-imputation function \code{cmultRepl()}}
}
\value{
An estimate of the requested metric of proportionality.
}
\description{
Naive (empirical) estimates of proportionality metrics using only the
observed counts.
}
\examples{
#' data(singlecell)

naiveVariation(singlecell)
naiveVariation(singlecell, type="phi")
naiveVariation(singlecell, type="rho")

}
