% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countland_subset.R
\name{SubsetGenes}
\alias{SubsetGenes}
\title{Subsets genes using a vector of gene indices}
\usage{
SubsetGenes(C, gene_indices, remove_empty = TRUE)
}
\arguments{
\item{C}{countland object}

\item{gene_indices}{vector of gene index values}

\item{remove_empty}{filter out cells and genes with no observed counts (default=TRUE)}
}
\value{
countland object, count matrix updated
}
\description{
Subsets genes using a vector of gene indices
}
\examples{
gold_path <- system.file("testdata", package = "countland", mustWork = TRUE)
gold.data <- Seurat::Read10X(data.dir = gold_path)
C <- countland(gold.data)
C <- SubsetGenes(C,gene_indices=1:200)
}
