% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mra.R
\name{mra}
\alias{mra}
\title{Perform Master Regulator Analysis (mra).}
\usage{
mra(
  expmat1,
  expmat2 = NULL,
  regulon,
  minsize = 10,
  nperm = NULL,
  nthreads = 2,
  verbose = FALSE,
  atacseq = NULL
)
}
\arguments{
\item{expmat1}{A numeric expression matrix, with genes/features as rows and samples as columns.
If only expmat1 is provided (without expmat2), the function will perform a sample-by-sample
master regulator analysis, with the mean of the dataset as a reference. If expmat2 is provided,
expmat1 will be considered the "treatment" sample set. If a named vector is provided, with names
as genes/features and values as signature values (e.g. T-test statistics), signature
master regulator analysis is performed.}

\item{expmat2}{A numeric expression matrix, with genes/features as rows and samples as columns.
If provided, it will be considered as the "control" or "reference" sample set for expmat1.}

\item{regulon}{A _regulon_ object, output of the _corto_ function.}

\item{minsize}{A minimum network size for each centroid/TF to be analyzed. Default is 10.}

\item{nperm}{The number of times the input data will be permuted to generate null signatures.
Default is 1000 if expmat2 is provided, and 10 if expmat2 is not provided (single sample mra).}

\item{nthreads}{The number of threads to use for generating null signatures. Default is 1}

\item{verbose}{Boolean, whether to print full messages on progress analysis. Default is FALSE}

\item{atacseq}{An optional 3 column matrix derived from an ATAC-Seq analysis, indicating
1) gene symbol, 2) -log10(FDR)*sing(log2FC) of an ATAC-Seq design, 3) distance from TSS.
If provided, the output will contain an _atacseq_ field.}
}
\value{
A list summarizing the master regulator analysis
\itemize{
\item nes: the normalized enrichment score: positive if the centroid/TF network is upregulated
in expmat1 vs expmat2 (or in expmat1 vs the mean of the dataset), negative if downregulated. A
vector in multisample mode, a matrix in sample-by-sample mode.
\item pvalue: the pvalue of the enrichment.
\item sig: the calculated signature (useful for plotting).
\item regulon: the original regulon used in the analysis (but filtered for _minsize_)
\item atac: Optionally present if atacseq data is provided. For each centroid/TF a number
ranging from 0 to 1 will indicate the fraction of changes in activity due to promoter effects
rather than distal effects.
}
}
\description{
The analysis is performed between two groups of samples in the form of expression matrices,
with genes/features as rows and samples as columns.
}
