% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{vCopula}
\alias{vCopula}
\alias{vCopula,matrix,matrix-method}
\alias{vCopula,matrix,matrix,Copula}
\title{Copula volume on hyper-boxes}
\usage{
vCopula(u, v, copula, ...)

\S4method{vCopula}{matrix,matrix}(u, v, copula)
}
\arguments{
\item{u}{numeric matrix : minimum point of the hyper-rectangles, one row per observation.}

\item{v}{numeric matrix : maximum point of the hyper-rectangle, one row per observation.}

\item{copula}{the copula that we compute the measure on the box (u,v)}

\item{...}{other parameter to be passed to methods for this generic.}
}
\value{
the measure of the copula.
}
\description{
u must be piecewise smaller than v, otherwise the function will return an error.
}
\details{
A method is currently implemented for the main virtual class 'Copula', but it assumes
that a pCopula method is avaliable for the given copula.

This function computes the measure of the copula according to the algorithm proposed by the referenced paper.
}
\examples{
cop <- cbCopula(LifeCycleSavings,m = 5)
vCopula(rep(0,5),rep(1,5),cop) == 1
vCopula(rep(0,5),rep(0.5,5),cop)

}
\references{
\insertRef{cherubini2009}{cort}
}
