% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_simpson.R
\name{simulate_simpson}
\alias{simulate_simpson}
\title{Simpson's paradox dataset simulation}
\usage{
simulate_simpson(n = 100, r = 0.5, groups = 3, difference = 1)
}
\arguments{
\item{n}{The number of observations to be generated.}

\item{r}{A value or vector corresponding to the desired correlation coefficients.}

\item{groups}{Number of groups.}

\item{difference}{Difference between groups.}
}
\value{
A dataset.
}
\description{
Simpson's paradox, or the Yule–Simpson effect, is a phenomenon in probability and statistics, in which a trend appears in several different groups of data but disappears or reverses when these groups are combined.
}
\examples{
data <- simulate_simpson(n = 100, groups = 5, r = 0.5)

library(ggplot2)
ggplot(data, aes(x=V1, y=V2)) +
  geom_point(aes(color=Group)) +
  geom_smooth(aes(color=Group), method="lm") +
  geom_smooth(method="lm")

}
