% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{COMURE}
\alias{COMURE}
\title{The Use of Linguistic Variants in Translations vs. Non-translations and in Six Different Registers}
\format{A data frame with 3762 rows and 4 variables.
\itemize{
  \item{\code{Variant} }{The linguistic variant used in a set of alternatives (27 levels).}
  \item{\code{Variable} }{The linguistic variable specifying a set of alternatives (13 levels).}
  \item{\code{Register} }{The register or "Text type" of the data (6 levels).}
  \item{\code{Language} }{The language (and source language) of the data (3 levels).}
}}
\source{
Delaere, I., G. De Sutter and K. Plevoets (2012) Is translated language more standardized than non-translated language? \emph{Target} \strong{24} (2), 203--224.
}
\description{
This data set was a case study in the COMURE project ("\strong{co}rpus-based, \strong{mu}ltivariate research of \strong{re}gister variation in translated and
  non-translated Belgian Dutch") which was conducted at the Department of Translation, Interpreting and Communication of Ghent University between 2010 and 2014.
}
\examples{
\donttest{
data(COMURE)
# The execution of corregp may be slow, due to bootstrapping:
comure.crg <- corregp(Variant ~ Register * Language, data = COMURE, part = "Variable", b = 3000)
comure.crg
summary(comure.crg, parm = "b", add_ci = TRUE)
screeplot(comure.crg, add_ci = TRUE)
comure.col <- ifelse( xtabs(~ Variant + Variety, data = COMURE)[, "Standard"] > 0, "blue", "red")
plot(comure.crg, x_ell = TRUE, xsub = c("Register", "Language"), col_btm = comure.col,
  col_top = "black")
}
}

