% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{.compare}
\alias{.compare}
\title{Performance measurement}
\usage{
.compare(y, cutoff, X, alpha = 1, nfolds = 5, foldid = NULL,
  type.measure = "deviance")
}
\arguments{
\item{y}{continuous outcome\strong{:}
vector of length \eqn{n}}

\item{cutoff}{cut-off point for dichotomising outcome into classes\strong{:}
\emph{meaningful} value between \code{min(y)} and \code{max(y)}}

\item{X}{features\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{alpha}{elastic net mixing parameter\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{nfolds}{number of folds\strong{:}
integer between \eqn{3} and \eqn{n}}

\item{foldid}{fold identifiers\strong{:}
vector with entries between \eqn{1} and \code{nfolds};
or \code{NULL} (balance)}

\item{type.measure}{loss function for binary classification\strong{:}
character \code{"deviance"}, \code{"mse"}, \code{"mae"},
or \code{"class"} (see \code{\link[glmnet]{cv.glmnet}})}
}
\description{
Compares models for a continuous response with a cut-off value.
}
\details{
Uses k-fold cross-validation,
fits linear, logistic, and combined regression,
calculates different loss functions,
and examines squared deviance residuals.
}
\examples{
\dontshow{n <- 20; p <- 10
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
loss <- cornet:::.compare(y=y,cutoff=0,X=X,nfolds=2)
loss}
\donttest{n <- 100; p <- 200
y <- rnorm(n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
loss <- cornet:::.compare(y=y,cutoff=0,X=X)
loss}

}
