\name{plot.cca}
\alias{plot.cca}
\title{
Plotting function for CCA modules.
}
\description{
Plot a CCA-produced module as a network diagram. The network nodes are survey variables (columns), and the ties are their correlations.  Red (or dashed) ties represent negative correlations.
This is a convenience function wrapping igraph's graphing functionality.  Writing to a file is done via the Cairo package.
}
\usage{
\method{plot}{cca}(x, module.index, cutoff = 0.05, LAYOUT = layout.kamada.kawai, 
    drop.neg.ties.for.layout = TRUE, bw = FALSE, main = NULL, file = NULL, ...)
}
\arguments{
  \item{x}{
The cca object returned by \code{\link{cca}}.
}
  \item{module.index}{
Index of module to plot, between 1 and length(x$modules).
}
  \item{cutoff}{
Minimum absolute column correlation to plot.
}
  \item{LAYOUT}{
If this is a function, it is assumed to be one of the layout routines from igraph (or something that returns data in the same format).  Otherwise, it is assumed to be the layout returned by such a function.
}
  \item{drop.neg.ties.for.layout}{
Whether to drop negative ties for the purpose of layout. This may be necessary because some layout algorithms do not work if negative ties are present. Note that the negative ties are only dropped for the purposes of layout.  They will still included in the actual plot.
}
  \item{bw}{
Whether to print in color for screen viewing (FALSE), or in b&w with dashed lines for negative ties for a journal manuscript (TRUE).
}
  \item{main}{
Caption at the top of the graph.  If NULL, the module number is used as the caption.
}
  \item{file}{
If a filename is provided, the graph is saved as a pdf with that filename. Note that this requires the Cairo package.
}
  \item{...}{
Unused.
}
}
\value{
If the LAYOUT paramter is a layout function, then the return value is the static layout generated by this function (this allows the same exact layout to be reproduced in the future--see example below).  Otherwise, it is the same static layout that was passed to plot.cca.
}
\author{
Andrei Boutyline, \email{andrei.boutyline@gmail.com}
}


\seealso{
\code{\link{cca}}
}
\examples{
    data(cca.example)
    res1 <- cca(cca.example) # with igraph 0.7, this should find 3 classes of sizes 218 391 144.
    plot(res1, 1) # plot the first module
    plot(res1, 2) # plot the second module
    plot(res1, 3) # plot the third module
    
    plot(res1, 1, bw = TRUE) # check out first module in black and white
    plot(res1, 1, LAYOUT = layout.fruchterman.reingold) # try a different layout algorithm
    
    # example of saving a fixed layout
    layout1 <- plot(res1, 1) # try out a layout ...
    layout1 <- plot(res1, 1) # ... try again
    layout1 <- plot(res1, 1) # ... until one looks good
    plot(res1, 1, LAYOUT = layout1, file = "module1.pdf") # now save it to a file
}
