% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copCAR.R
\name{rcopCAR}
\alias{rcopCAR}
\title{Simulate areal data.}
\usage{
rcopCAR(rho, beta, X, A, family)
}
\arguments{
\item{rho}{the spatial dependence parameter \eqn{\rho} such that \eqn{\rho \in [0, 1)}.}

\item{beta}{the vector of regression coefficients \eqn{\beta = (\beta_1, \dots, \beta_p)'}.}

\item{X}{the \eqn{n} by \eqn{p} design matrix \eqn{X}.}

\item{A}{the symmetric binary adjacency matrix for the underlying graph. \code{\link{adjacency.matrix}} generates the adjacency matrix for the \eqn{m} by \eqn{n} square lattice.}

\item{family}{the marginal distribution of the observations and link function to be used in the model. This can be a character string naming a family function, a family function, or the result of a call to a family function. (See \code{\link{family}} for details of family functions.) Supported familes are \code{binomial}, \code{poisson}, and \code{negbinomial}.}
}
\value{
A vector of length \eqn{n} distributed according to the specified copCAR model.
}
\description{
\code{rcopCAR} simulates areal data from the copCAR model.
}
\details{
This function simulates data from the copCAR model with the given spatial dependence parameter \eqn{\rho}, regression coefficients \eqn{\beta}, design matrix \eqn{X}, and adjacency structure \eqn{A}. For negative binomial marginal distributions, a value for the dispersion parameter \eqn{\theta>0} is also required; this value must be passed to the \code{\link{negbinomial}} family function. For more details on the copCAR model, see \code{\link{copCAR}}.
}
\examples{

# Use the 20 x 20 square lattice as the underlying graph.

m = 20
A = adjacency.matrix(m)

# Create a design matrix by assigning coordinates to each vertex
# such that the coordinates are restricted to the unit square.

x = rep(0:(m - 1) / (m - 1), times = m)
y = rep(0:(m - 1) / (m - 1), each = m)
X = cbind(x, y)

# Set the dependence parameter and regression coefficients.

rho = 0.995      # strong dependence
beta = c(1, 1)   # the mean surface increases in the direction of (1, 1)

# Simulate Poisson data from the corresponding copCAR model.

z = rcopCAR(rho, beta, X, A, family = poisson(link = "log"))

# Simulate Bernoulli outcomes.

Z = rcopCAR(rho, beta, X, A, family = binomial(link = "logit"))

# Set the dispersion parameter.

theta = 10

# Simulate negative binomial outcomes.

Z = rcopCAR(rho, beta, X, A, family = negbinomial(theta))
}

