% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/productLinearProblem.R
\name{productLinearProblem}
\alias{productLinearProblem}
\title{Linear production programming problems}
\usage{
productLinearProblem(c, A, b, plot = FALSE, show.data = FALSE)
}
\arguments{
\item{c}{vector of benefits.}

\item{A}{production matrix.}

\item{b}{vector of resources.}

\item{plot}{logical value indicating  if the function displays graphical 
solution (\code{TRUE}) or not (\code{FALSE}). Note that this option only makes 
sense when we have a two-dimension problem.}

\item{show.data}{logical value indicating if the function displays the 
console output (\code{TRUE}) or not (\code{FALSE}). By default the 
value is \code{TRUE}.}
}
\value{
\code{productLinearProblem} returns and prints a list with the 
following components:

\code{ObjetiveValue} Value of the objetive function from a successfully solved 
linear production programming problem.

\code{OptimalSolution} Values of the variables from a successfully solved linear 
production programming problem.
}
\description{
Given a linear production programming problem \code{A \%*\% x <= b}, the
\code{productLinearProblem} solves the problem by making use of
 \code{lpSolveAPI}.
}
\examples{
# Vector of benefits
c <- c(68,52)
# Production matrix
A <- matrix(c(4,5,6,2),ncol=2, byrow = TRUE)
# Matrix of resources. Each row is the vector of resources of each player
b <- c(4,33)
# Solution of the associated linear production game
productLinearProblem(c,A,b, show.data = TRUE)

# ------------------------------------------------------------------------
# Objetive value: 
# ------------------------------------------------------------------------
#   [1] "Z = 68"
# 
# ------------------------------------------------------------------------
# Optimal solution: 
# ------------------------------------------------------------------------
#   [1] 1 0
# ------------------------------------------------------------------------
  
}
\author{
D. Prieto
}
