% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindata.R
\name{bindata}
\alias{bindata}
\title{Bin two-dimensional data in one dimension}
\usage{
bindata(x, y = NULL, bins = 20, method = "regular", xlim = NULL)
}
\arguments{
\item{x}{N-element vector of x-coordinates}

\item{y}{optional N-element vector of values associated with the different points in x}

\item{bins}{If method is 'regular' or 'equal', this is a scalar specifying the number of bins. If method is 'custom' this is a vector of (n+1) x-values delimiting the n bins.}

\item{method}{Character string. Choose 'regular' for regularly space bins, 'equal' for bins containing an equal number of points (+-1), or 'custom' for bins with custom edges.}

\item{xlim}{optional 2-element vector specifying the data range (data cropped if necessary). If not given, xlim is set to the full range of x.}
}
\value{
Returns a list of items
\item{n}{number of bins}
\item{xlim}{considered range of x-coordinates, same as input argument xlim, if given}
\item{xleft}{n-element vector containing the x-coordinates of the left bin edges}
\item{xmid}{n-element vector containing the x-coordinates of the bin centres}
\item{xright}{n-element vector containing the x-coordinates of the right bin edges}
\item{dx}{n-element vector containing the widths of the bins}
\item{count}{n-element vector containing the number of points in each bin}
\item{x}{n-element vector containg the mean x-values in each bin}
\item{y}{n-element vector containg the mean y-values in each bin}
\item{xmedian}{n-element vector containg the median of the x-values in each bin}
\item{ymedian}{n-element vector containg the median of the y-values in each bin}
\item{yerr}{n-element vector giving the uncertainty on the mean}
\item{ysd}{n-element vector giving the standard deviations of the y-values}
\item{y16}{n-element vector giving the 15.86-percentile of the y-values}
\item{y84}{n-element vector giving the 84.13-percentile of the y-values}
}
\description{
Divides a vector of values x into finite intervals; returns the counts and other statistics in each interval.
}
\examples{
# make and plot 100 random (x,y)-points
set.seed(1)
x = runif(200)
y = x+rnorm(200)
plot(x,y,pch=16,cex=0.5)

# bin the data into 10 bins of 20 points each
bin = bindata(x,y,10,'equal')
segments(bin$xleft,bin$y,bin$xright,bin$y,col='red')
segments(bin$x,bin$y16,bin$x,bin$y84,col='red')
segments(bin$x,bin$y-bin$yerr,bin$x,bin$y+bin$yerr,col='red',lwd=3)
points(bin$x,bin$y,pch=16,col='red')

}
\seealso{
\code{\link{griddata}}
}
\author{
Danail Obreschkow
}
