% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convoSPAT_fitpred.R
\name{predict.Aniso}
\alias{predict.Aniso}
\title{Obtain predictions at unobserved locations for the stationary
spatial model.}
\usage{
\method{predict}{Aniso}(object, pred.coords, pred.covariates = NULL, ...)
}
\arguments{
\item{object}{An "Aniso" object, from \code{Aniso_fit}.}

\item{pred.coords}{Matrix of locations where predictions are required.}

\item{pred.covariates}{Matrix of covariates for the prediction locations,
NOT including an intercept. The number of columns for this matrix must
match the design matrix from \code{mean.model} in \code{\link{NSconvo_fit}}.
Defaults to an intercept only.}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
A list with the following components:
\item{pred.means}{Vector of the kriging predictor, for each location in
\code{pred.coords}.}
\item{pred.SDs}{Vector of the kriging standard errors, for each location
in \code{pred.coords}.}
}
\description{
\code{predict.Aniso} calculates the kriging predictor and corresponding
standard errors at unmonitored sites.
}
\examples{
\dontrun{
pred.S <- predict( Aniso.obj,
pred.coords = cbind(runif(300),runif(300)) )
}

}

