% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyjdivdec.R
\name{svyjdivdec}
\alias{svyjdivdec}
\alias{svyjdivdec.survey.design}
\alias{svyjdivdec.svyrep.design}
\alias{svyjdivdec.DBIsvydesign}
\title{J-Divergence Decomposition (EXPERIMENTAL)}
\usage{
svyjdivdec(formula, subgroup, design, ...)

\method{svyjdivdec}{survey.design}(formula, subgroup, design, na.rm = FALSE,
  ...)

\method{svyjdivdec}{svyrep.design}(formula, subgroup, design, na.rm = FALSE,
  ...)

\method{svyjdivdec}{DBIsvydesign}(formula, subgroup, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable}

\item{subgroup}{a formula specifying the group variable}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{na.rm}{Should cases with missing values be dropped? Observations containing missing values in income or group variables will be dropped.}
}
\value{
Object of class "\code{cvydstat}", which are vectors with a "\code{var}" attribute giving the variance-covariance matrix and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimates the group decomposition of the generalized entropy index
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.

This measure only allows for strictly positive variables.
}
\note{
This function is experimental and is subject to change in later versions.
}
\examples{
library(survey)
library(vardpoor)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)

# linearized design
svyjdivdec( ~eqincome , ~rb090 , subset(des_eusilc, eqincome > 0) )

# replicate-weighted design
svyjdivdec( ~eqincome , ~rb090 , subset(des_eusilc_rep, eqincome > 0) )

\dontrun{

# linearized design using a variable with missings
sub_des_eusilc <- subset(des_eusilc, py010n > 0 | is.na(py010n) )
svyjdivdec( ~py010n , ~rb090 , sub_des_eusilc )
svyjdivdec( ~py010n , ~rb090 , sub_des_eusilc , na.rm = TRUE )

# replicate-weighted design using a variable with missings
sub_des_eusilc_rep <- subset(des_eusilc_rep, py010n > 0 | is.na(py010n) )
svyjdivdec( ~py010n , ~rb090 , sub_des_eusilc_rep )
svyjdivdec( ~py010n , ~rb090 , sub_des_eusilc_rep , na.rm = TRUE )

# database-backed design
library(MonetDBLite)
library(DBI)
dbfolder <- tempdir()
conn <- dbConnect( MonetDBLite::MonetDBLite() , dbfolder )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfolder,
		dbtype="MonetDBLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )

# database-backed linearized design
svyjdivdec( ~eqincome , ~rb090 , subset(dbd_eusilc, eqincome > 0) )

# database-backed linearized design using a variable with missings
sub_dbd_eusilc <- subset(dbd_eusilc, py010n > 0 | is.na(py010n) )
svyjdivdec( ~py010n , ~rb090 , sub_dbd_eusilc )
svyjdivdec( ~py010n , ~rb090 , sub_dbd_eusilc , na.rm = TRUE )

dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Anthony F. Shorrocks (1984). Inequality decomposition
by population subgroups. \emph{Econometrica}, v. 52, n. 6, 1984, pp. 1369-1385.
URL \url{http://www.jstor.org/stable/1913511}.

Nicholas Rohde (2016). J-divergence measurements of economic inequality.
J. R. Statist. Soc. A, v. 179, Part 3 (2016), pp. 847-870.
URL \url{http://onlinelibrary.wiley.com/doi/10.1111/rssa.12153/abstract}.

Martin Biewen and Stephen Jenkins (2002). Estimation of Generalized Entropy
and Atkinson Inequality Indices from Complex Survey Data. \emph{DIW Discussion Papers},
No.345,
URL \url{https://www.diw.de/documents/publikationen/73/diw_01.c.40394.de/dp345.pdf}.
}
\seealso{
\code{\link{svyjdiv}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
